using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_PM25SpeciesOptionChina : UserControl
    {
        public uc_PM25SpeciesOptionChina()
        {
            InitializeComponent();
        }

        string path = "";


        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20191119
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina = new PM25SpeciesOptionChina();
                if (CommonClass.dicExampleConfiguration != null)
                {
                    CommonClass.speciesMonitorFile = CommonClass.dicExampleConfiguration["AnnualPM"]["speciesMonitorDataFile"];// Application.StartupPath + @"\Data\SampleData\SMAT-China\PM25_Species_Fraction_Quarterly_2013_YRD.csv";
                    txtSpeciesDataChina.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                    chkSpeciesFractionDataChina.Checked = CommonClass.dicExampleConfiguration["AnnualPM"].ContainsKey("PM25SpeciesFractionDataAvailable") ? bool.Parse(CommonClass.dicExampleConfiguration["AnnualPM"]["PM25SpeciesFractionDataAvailable"]) : false;
                }
            }
            else
            {
                chkSpeciesFractionDataChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.PM25SpeciesFractionDataAvailable;
                CommonClass.speciesMonitorFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.SpeciesMonitorDataFile;
                txtSpeciesDataChina.Text = Path.GetFileName(CommonClass.speciesMonitorFile);
                //txtSpeciesDataChina.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).pm25SpeciesOptionChina.SpeciesMonitorDataFile;
            }
        }

        private void uc_PM25SpeciesOptionChina_Load(object sender, EventArgs e)
        {
            chkSpeciesFractionDataChina_CheckedChanged(sender, e);
        }

        private void chkSpeciesFractionDataChina_CheckedChanged(object sender, EventArgs e)
        {
            if (chkSpeciesFractionDataChina.Checked == true)
            {
                txtSpeciesDataChina.Enabled = true;
                txtSpeciesDataChina.BackColor = Color.White;
                btnOpenMonitorFileChina.Enabled = true;
            }
            else
            {
                txtSpeciesDataChina.Enabled = false;
                txtSpeciesDataChina.BackColor = SystemColors.Control;
                btnOpenMonitorFileChina.Enabled = false;
            }
        }

        private void btnOpenMonitorFileChina_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog open = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.speciesMonitorFile) || System.IO.Directory.Exists(CommonClass.speciesMonitorFile))
                    {
                        open.InitialDirectory = Application.StartupPath + @"\Data\SampleData\";
                    }
                    else
                    {
                        open.InitialDirectory = Path.GetDirectoryName(CommonClass.speciesMonitorFile);
                    }
                }
                else
                    open.InitialDirectory = path;
                open.Title = LanguageOld.Translate("Select file...");
                open.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (open.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.speciesMonitorFile = open.FileName;
                    txtSpeciesDataChina.Text = Path.GetFileName(open.FileName);
                    path = Path.GetDirectoryName(open.FileName);
                    open.RestoreDirectory = true;
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            } 
        }
    }
}
